define(['angular', 'app'], function (angular, app) {
	"use strict";
	
    app.service('userService', function ($http, $q, localResourceDirectoryService) {
        var userService = {};
        var user = {};
        var request;

        userService.getUserData = function() {
            if (request) {
                return request.promise;
            } 
            request = $q.defer();

            localResourceDirectoryService.fetch().then(function(directory) {
                $http({
                    method: 'GET',
                    url: directory['users-session'],
                }).then(function(response) {
                     localResourceDirectoryService.updatePatientIdentifiers(response.data);


                    request.resolve(response.data);
                }, function(error) {
                    request.reject(error);
                });
            });

            return request.promise;
        };

        userService.refreshJwt = function() {
            return $http.get(localResourceDirectoryService['refresh-jwt']);
        };

        return userService;
    });
});